/*****************************************
 * File: SwingApplet.java
 * @autor
 */
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.applet.*;
import javax.swing.*;
import javax.swing.filechooser.*;
import java.lang.*;
import java.lang.Runtime;
import java.util.*;
import java.io.*;
import java.io.InputStream.*;
import java.io.OutputStream;
import java.lang.Math.*;

public class ABSApplet extends JApplet 
{ 
 public static ARABS ModelAR_ABS;
 public static MyLp Solver;
 public static Prediction Pred;
  
 String Name1 = "Model", Name2 = "Inputs",Name3 = "Count";
 String IFile = new String();
 String Model = new String();
 String DefaultFile = new String("armatest");              //////////////////////////////////
 String Dir= new String();
 int width = 150, height = 28, Left;
 int ParamWidth, ParamHeight, fc=0; 
 boolean Bcompare= false;
 JProgressBar wProgressBar = new JProgressBar();
 JTextArea t = new JTextArea(14,40);
 JButton w11Button, w12Button,
 w1Button, w2Button, w3Button, w4Button; 
 JLabel  wLabel,
 w11Label, w12Label, w13Label,
 w21Label, w22Label,  w2nLabel[] = new JLabel[ModelAR_ABS.InputsNumber],
 w31Label;
 JTextField w11TextField,
 w2nTextField[] = new JTextField[ModelAR_ABS.InputsNumber];
 JComboBox w11ComboBox;
 JTabbedPane wTabbedPane = new JTabbedPane();
 JPanel wPanel, w1Panel, w2Panel, w3Panel;
 JScrollPane wScrollPane;
 JPopupMenu wPopupMenu1,  wPopupMenu2, wPopupMenu3; 
 JMenuItem wMenuItem1,wMenuItem2,wMenuItem3;
 Color wColor = new Color(222, 222, 222); // ComboBox BackGround color
 Vector wItVector = new Vector(0), wFVector = new Vector(0);
 JFrame  wGFrame;
 int Iterations;
 public static int FileIdent;
 ReadDataFile  RDF;
 PerformCount  PC;
//--------------- MouseListener ------------------Popup Menu adapter--------------------------------
 class CPMouseAdapter extends MouseAdapter
 {
  public void mouseReleased(MouseEvent e)
  {
   if (e.isPopupTrigger())
   {
    if(e.getSource()==w1Panel)
     wPopupMenu1.show(e.getComponent(), e.getX(), e.getY());
    else if (e.getSource()==w2Panel)
     wPopupMenu2.show(e.getComponent(), e.getX(), e.getY());
    else
     wPopupMenu3.show(e.getComponent(), e.getX(), e.getY());
   }
  }
 }   
 CPMouseAdapter wPMouseAdapter = new CPMouseAdapter();
 //------------------ActionListener---------------Help File Invoker-----------------------------------------
 class Popup1 implements ActionListener
 {
  ReadDataFile  RDF= new ReadDataFile();
  public void actionPerformed(ActionEvent e)
  {
   String Fi = new String();
   Object object = e.getSource();
   if (object== wMenuItem1)
    Fi= "Help1";
   else if (object== wMenuItem2)
    Fi= "Help2";
   else if  (object== wMenuItem3)
    Fi= "Help3";
   String path= new String();
   path= "";
   OutputFrame out = new OutputFrame("HELP Window...");
   RDF.SimpleRead(path, Fi,out.text );
   out.setSize( 500, 700 );
   out.setVisible( true );
  }
 }

//---------ActionListener---------------Geting and  controling values from Imputs-----------------------------------------
 class CSFocusListener implements FocusListener
 {
  public void focusGained(FocusEvent e)
  {        
  }
  public void focusLost(FocusEvent e)
  {
   int  aa=0;
   boolean ex=false;
   String Str = ((JTextField)e.getSource()).getText();
   Object object = e.getSource();
   try
   {
    aa=  Long.valueOf(Str).intValue();
   }
   catch(NumberFormatException exc)                
   {
    ex= true;
   }
   if ((aa<0)||( ex))
   {
    ex= true;
    fc=fc+1;
    if (fc == 3) fc = 1; 
    if (fc == 1)
    {
     JOptionPane.showMessageDialog(null, "Field value must be a number!", "Warning!", JOptionPane.WARNING_MESSAGE);
    }
   }                
   if (object ==  w2nTextField[0])
   {
    if(ex)
     w2nTextField[0].setText(""+ModelAR_ABS.class0);
    else
     ModelAR_ABS.class0 =aa;
   }
   else if (object ==  w2nTextField[1])
   {
    if(ex)
     w2nTextField[1].setText(""+ModelAR_ABS.class1);
    else
    {
     ModelAR_ABS.class1 =aa;
     if (aa>=ModelAR_ABS.class2)
     {
      fc=fc+1;
      if (fc == 3) fc = 1; 
      if (fc == 1)
      {
       JOptionPane.showMessageDialog(null, "p value must be less than T!", "Warning!", JOptionPane.WARNING_MESSAGE);
       ARABS.class2 =ModelAR_ABS.class1 + 1;
       w2nTextField[2].setText(""+ ARABS.class2);
      }
     }
    }  
   }
   else if (object==  w2nTextField[2] )
   {
    if(ex)
     w2nTextField[2].setText(""+ModelAR_ABS.class2);
    else
    {    
     ModelAR_ABS.class2 =aa;
     if (aa<=ModelAR_ABS.class1)
     {
      fc=fc+1;
      if (fc == 3) fc = 1; 
      if (fc == 1) 
      {   
       JOptionPane.showMessageDialog(null, "p value must be less than T!", "Warning!", JOptionPane.WARNING_MESSAGE);
       if (ModelAR_ABS.class2 >0)
       {
        ARABS.class1 =ModelAR_ABS.class2 - 1;
        w2nTextField[1].setText(""+ ARABS.class1);
       }
       else
       {
        ARABS.class2 =ModelAR_ABS.class1 + 1;
        w2nTextField[2].setText(""+ ARABS.class2);
       }
      } 
     }
    }
   }
   else if (object==  w2nTextField[3] )
   {
    if(ex)
      w2nTextField[3].setText(""+ModelAR_ABS.class3);
    else if (aa==0)
    {  
     ModelAR_ABS.class3 =aa;
     w3Button.setEnabled(false);
    }
    else if (aa==1)
     ModelAR_ABS.class3 =aa;
    else
    {
     fc=fc+1;
     if (fc == 3) fc = 1; 
     if (fc == 1)
     {
      JOptionPane.showMessageDialog(null, "Indicator value must be 0 or 1!", "Warning!", JOptionPane.WARNING_MESSAGE);
      ModelAR_ABS.class3 =0;
      w2nTextField[3].setText("0");
     }
    }
   }
   else if (object==  w2nTextField[4] )
   {
    if(ex)
     w2nTextField[4].setText(""+ModelAR_ABS.class4);
    else if (aa==0)
    {  
     ModelAR_ABS.class4 =aa;
     w3Button.setEnabled(false);
    }
    else if (aa==1)
     ModelAR_ABS.class4 =aa;
    else
    {
     fc=fc+1;
     if (fc == 3) fc = 1; 
     if (fc == 1)
     {
      JOptionPane.showMessageDialog(null, "Indicator value must be 0 or 1!", "Warning!", JOptionPane.WARNING_MESSAGE);
      ModelAR_ABS.class4 =0;
      w2nTextField[4].setText("0");
     }
    }
   }
  }
 }
 CSFocusListener wTSFocusListener = new CSFocusListener();  
 
//--------------ActionListener--------------- File Chooser-----------------------------------------
 class CFActionListener implements ActionListener
 {
  public void actionPerformed(ActionEvent e)
  {
   try
   {
    JFileChooser wFileChooser = new JFileChooser();
    wFileChooser.setLocation( 250,250);
    wFileChooser.changeToParentDirectory();
    int returnVal = wFileChooser.showOpenDialog(w1Panel); 
    if(returnVal == JFileChooser.APPROVE_OPTION) 
    {
     IFile=wFileChooser.getSelectedFile().getName();
     w11TextField.setText(IFile);
     Dir= wFileChooser.getCurrentDirectory().getAbsolutePath()+"/"+IFile;
    } 
   }
   finally {}
  }
 }
 CFActionListener wFActionListener = new CFActionListener();

//---------ActionListener--------------------------------------------------------
 class PerformCount extends Thread
 {
  ReadDataFile  RDF= new ReadDataFile();
  int prog, inkr=0;
  boolean Stop = false, red= false;
  double[] TAll =new double[2000000];
  double[] PAll =new double[2000000];
  public void run()
  {
   OutputFrame out = new OutputFrame("LP problem....");
   Solver = new MyLp();
   Pred= new Prediction();
   double ar=0, rand;
   int tempP=ARABS.class1;
   int T= ARABS.class2;
   prog=0;
   if (wItVector.size() !=0)
   {
    wItVector.removeAllElements();
    wFVector.removeAllElements();
   }
   if((ARABS.class3==0)&&(ARABS.class4==0))
   {
    prog=10;
    wProgressBar.setMaximum(prog);
    Solver.MyLpSolve();
    wProgressBar.setValue(inkr++); 
    for (int i=1; i<=20; i++)
    {
//     out.text.setText("");
//     out.writeString( "Optimization problem for Lp_solve:\n");
     RDF.SimpleRead("", "in_data.lp",out.text );
//     out.writeString( "\n");
//     out.writeString( "Rezults returned from Lp_solve:\n");
     RDF.SimpleRead("", "out_data.lp",out.text );
//     out.writeString( "\n");
    }
     wProgressBar.setValue(inkr++); 
     if (Stop) Show(out);
     RDF.ReadLp( "", "",  t );
//     out.writeString( "  ----------------------Parameters: P = "+tempP+" ; T = "+T+"----------------------\n");
//     t.append( "  ----------------------Parameters: P = "+tempP+" ; T = "+T+"----------------------\n");
     wProgressBar.setValue(inkr++); 
     if (Stop) Show(out);
//     for (int i=1; i<= (ARABS.class1*ARABS.class0); i++)
//     {
//      t.append("   a[ "+i+" ]"+ ARABS.Acoef[i]+"\n");
//      out.writeString("   a[ "+i+" ]"+ARABS.Acoef[i]+"\n");
//     }
     wProgressBar.setValue(inkr++);
     if (Stop) Show(out);
     Pred.Residuals();
     wProgressBar.setValue(inkr++); 
     for (int i=2; i<= ARABS.class2; i++)
     {
//      out.writeString("Residuals ["+ i +"] "+ ARABS.Residuals[i]+"\n");
      ar=ar+Math.abs(ARABS.Residuals[i]);
     }
     wProgressBar.setValue(inkr++); 
     if (Stop) Show(out);
//     out.writeString("The average of residuals for known data: "+ar/(ARABS.class2-1)+"\n");
     ar=Pred.Predict();
     t.append("Next predicted: "+ar+"\n");
     out.writeString("Next predicted: "+ar+"\n");
     wProgressBar.setValue(inkr++); 
     t.append("Should be     : "+ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]+"\n");
     out.writeString("Should be     : "+ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]+"\n");
//     t.append("Residual      : "+(ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]-ar)+"\n");
//     out.writeString("Residual      : "+(ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]-ar)+"\n");
     wProgressBar.setValue(prog); 
     out.setSize( 400, 400 ); 
     out.setVisible( true );       
    }
//===============================================================================//  
    else  if ((ARABS.class3==0)&&(ARABS.class4==1)) 
    {
     prog=10;
     wProgressBar.setMaximum(prog);
     wProgressBar.setValue(inkr++);
     Solver.MyLpSolve();
     wProgressBar.setValue(inkr++); 
//     for (int i=1; i<=10000000; i++)
//     {
//      Math.sqrt(Math.abs(i-1/i+ 0.03)); 
//     }
     wProgressBar.setValue(inkr++); 
     if (Stop) Show(out);
     RDF.ReadLp( "", "",  t );
     wProgressBar.setValue(inkr++); 
//     for (int i=1; i<= (ARABS.class1*ARABS.class0); i++)
//     {
//      out.writeString("   a[ "+i+" ]"+ARABS.Acoef[i]+"\n");
//     }
     wProgressBar.setValue(inkr++);
     if (Stop) Show(out);
     TAll= Pred.PredictMulti();
     wProgressBar.setValue(inkr++); 
     Pred.Residuals();
     for (int i=2; i<= ARABS.class2; i++)
     {
//      out.writeString("Residuals ["+ i +"] "+ ARABS.Residuals[i]+"\n");
      ar=ar+Math.abs(ARABS.Residuals[i]);
     }
//     out.writeString("The average  of residuals for known data : "+ar/(ARABS.class2-1)+"\n");
     wProgressBar.setValue(inkr++); 
     if (Stop) Show(out);
//     out.writeString(" \nParameter p= "+tempP+"\n"); 
//     t.append("\n Parameter p= "+tempP+"\n"); 
//     out.writeString("_____________________________________________________________________\n\n");
//     out.writeString(" T.         Predicted               Should be                Residual            \n");
//     out.writeString("_____________________________________________________________________\n");
//     t.append("______________________________________________________________________\n\n");
//     t.append(" T.        Predicted         Should be          Residual            \n");
//     t.append("______________________________________________________________________\n"); 
     ar=0;
     for (int i=1; i<= ARABS.class2; i++)
     {
      rand= Math.round(100000*TAll[i]);
      rand=rand/100000;
//      out.writeString(" " +(i+ARABS.class2)+"       "+ rand+  "                 "+ ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]+"                 "+(ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]-TAll[i])+    "\n");   
//      t.append(" " +(i+ARABS.class2)+"       "+ rand+  "                 "+ ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]+"                 "+(ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]-TAll[i])+    "\n");
      ar= ar+ Math.abs(ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]-TAll[i]);
     } 
//     out.writeString("_____________________________________________________________________\n\n");
//     t.append("______________________________________________________________________\n"); 
     wProgressBar.setValue(inkr++); 
//     out.writeString("Sum of all residuals: "+ar+"\n");
//     t.append("Sum of all residuals: "+ar+"\n");
//     out.writeString("The average  of residuals: "+ar/ARABS.class2+"\n");
//     t.append("The average  of residuals: "+ar/ARABS.class2+"\n");   
     wProgressBar.setValue(prog); 
     out.setSize( 400, 400 ); 
     out.setVisible( true );  
    }  
//===============================================================================//  
    else  if ((ARABS.class3==1)&&(ARABS.class4==0)) 
    {
     prog=3*ARABS.class1;
     wProgressBar.setMaximum(prog); 
//     t.append("\n Parameter T= "+ARABS.class2+"\n");
//     t.append("______________________________________________________________________\n\n");
//     t.append(" p.        Predicted         Should be          Residual            \n");
//     t.append("______________________________________________________________________\n");        
     for (int P=1; P<=tempP; P++)
     {   
      ARABS.class1=P;
      Solver.MyLpSolve();
      wProgressBar.setValue(inkr++);
//      for (int i=1; i<=100000000; i++)
//      {
//        Math.sqrt(Math.abs(i-1/i+ 0.03)); 
//      }
      red=RDF.ReadLp( "", "",  t );
      red=RDF.ReadLp( "", "",  t );
      if (red)
      {
       if (Stop)
       {
       	Show(out);
        ARABS.class1= tempP;
       }       
//       out.writeString( "  ----------------------Parameters: P = "+P+" ; T = "+T+"----------------------\n");
//       for (int i=1; i<= ARABS.class1*ARABS.class1; i++)
//       {
//         out.writeString("   a[ "+i+" ]"+ARABS.Acoef[i]+"\n");
//       }
       if (Stop)
       {
       	Show(out);
        ARABS.class1= tempP;
       }
       wProgressBar.setValue(inkr++);      
       Pred.Residuals();
       ar=0;
       for (int i=2; i<= ARABS.class2; i++)
       {
//        out.writeString("Residuals ["+ i +"] "+ ARABS.Residuals[i]+"\n");
        ar=ar+Math.abs(ARABS.Residuals[i]);
       }
//       out.writeString("The average  of residuals for known data : "+ar/ARABS.class2+"\n");
       if (Stop)
       {
       	Show(out);
       	ARABS.class1= tempP;
       } 
//       out.writeString("   "+ar+"   "+ar/ARABS.class2+"\n");
       TAll[P]=Pred.Predict();
//       out.writeString("Next predicted: "+TAll[P]+"\n");
       wProgressBar.setValue(inkr++); 
//       out.writeString("Should be     : "+ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]+"\n");
//       out.writeString("Residual      : "+(ModelAR_ABS.past[(ARABS.class2*ARABS.class0+1)]-TAll[P])+"\n");
       rand= Math.round(100000*TAll[P]);
       rand=rand/100000;
//       t.append(" " +(P)+"       "+ rand+  "                 "+ ARABS.past[ARABS.class2*ARABS.class0+1]+"                 "+(ARABS.past[ARABS.class2*ARABS.class0+1]-TAll[P])+    "\n");
       if (Stop) 
       {
       	Show(out);
        ARABS.class1= tempP;
       }
      }
      else 
      {
//       t.append("Lp_solve have not found the solution to the problem.\n");
//       out.writeString("Lp_solve have not found the solution to the problem.\n");
      }
     }
//     out.writeString(" \nParameter T= "+ARABS.class2+"\n"); 
//     out.writeString("_____________________________________________________________________\n\n");
//     out.writeString(" p.         Predicted               Should be                Residual            \n");
//     out.writeString("_____________________________________________________________________\n");   
     ar=0;
     for (int i=1; i<= ARABS.class1; i++)
     {
      rand= Math.round(100000*TAll[i]);
      rand=rand/100000;
//      out.writeString(" " +(i)+"       "+ rand+  "                 "+ ARABS.past[ARABS.class2*ARABS.class0+1]+"                 "+(ARABS.past[ARABS.class2*ARABS.class0+1]-TAll[i])+    "\n");   
      ar= ar+Math.abs(ARABS.past[ARABS.class2*ARABS.class0+1]-TAll[i]);
      wItVector.addElement(new Integer(i));
      wFVector.addElement(new Double(Math.abs(ARABS.past[ARABS.class2*ARABS.class0+1]-TAll[i])));
     } 
//     out.writeString("_____________________________________________________________________\n\n");
//     t.append("______________________________________________________________________\n"); 
     wProgressBar.setValue(inkr++); 
//     out.writeString("Sum of all residuals: "+ar+"\n");
//     t.append("Sum of all residuals: "+ar+"\n");
//     out.writeString("The average  of residuals: "+ar/ARABS.class1+"\n");
//     t.append("The average  of residuals: "+ar/ARABS.class1+"\n");      
     wProgressBar.setValue(prog);
     out.setSize( 400, 400 ); 
     out.setVisible( true );
     ARABS.class1= tempP; 
    }
//===============================================================================//  
    else  if ((ARABS.class3==1)&&(ARABS.class4==1)) 
    {
     int optimalp=1;
     prog=3*ARABS.class1;
     wProgressBar.setMaximum(prog);
//     t.append("\n The optimization of p parameter:\n");
//     t.append("_________________________________________________\n\n");
//     t.append(" p.          The average of residuals            \n");
//     t.append("__________________________________________________\n");    
     for (int P=1; P<=tempP; P++)
     {   
      ARABS.class1=P;
      Solver.MyLpSolve();
      wProgressBar.setValue(inkr++);
//      for (int i=1; i<=100000000; i++)
//      {
//       Math.sqrt(Math.abs(i-1/i+ 0.03)); 
//      }
      if (Stop)
      {
       Show(out);
       ARABS.class1= tempP;
      }     
      red=RDF.ReadLp( "", "",  t );
      if (red)
      {
       TAll= Pred.PredictMulti(); 
       if (Stop)
       {
       	Show(out);
        ARABS.class1= tempP;
       } 
//       out.writeString(" \nParameter p= "+P+"\n"); 
//       out.writeString("_____________________________________________________________________\n\n");
//       out.writeString(" T.         Predicted               Should be                Residual            \n");
//       out.writeString("_____________________________________________________________________\n");
       ar=0;
       for (int i=1; i<= ARABS.class2; i++)
       {
        rand= Math.round(100000*TAll[i]);
        rand=rand/100000;
//        out.writeString(" " +(i+ARABS.class2)+"       "+ rand+  "                 "+ ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]+"                 "+(ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]-TAll[i])+    "\n");   
        ar= ar+Math.abs(ARABS.past[(i-1)*ARABS.class0+1 +ARABS.class2*ARABS.class0]-TAll[i]);
       } 
//       out.writeString("_____________________________________________________________________\n\n");
       wProgressBar.setValue(inkr++); 
//       out.writeString("Sum of all residuals: "+ar+"\n");
//       out.writeString("The average  of residuals: "+ar/ARABS.class2+"\n");
       PAll[P]=ar;
//       t.append(" " +(P)+"       "+ PAll[P]/ARABS.class2+  "\n");
       wItVector.addElement(new Integer(P));
       wFVector.addElement(new Double(Math.abs(PAll[P]/ARABS.class2)));
      }
     }
     if (Stop)
     {
      Show(out);
      ARABS.class1= tempP;
     }  
     ar= PAll[1];
//     out.writeString("\n The optimization of p parameter:\n"); 
//     out.writeString("_________________________________________________\n\n");
//     out.writeString(" p.          The average of residuals            \n");
//     out.writeString("__________________________________________________\n");      
     for (int i=1; i<= ARABS.class1; i++)
     {
//      out.writeString(" " +(i)+"       "+ PAll[i]/ARABS.class2+     "\n"); 
      if (PAll[i]<ar)
      {
       ar=PAll[i];
       optimalp=i;
      } 
     } 
//     out.writeString("_________________________________________________\n\n");
//     t.append("_________________________________________________\n\n"); 
     if (Stop)
     {
      Show(out);
      ARABS.class1= tempP;
     }     
    wProgressBar.setValue(inkr++); 
//    out.writeString("The optimal p parameter: "+optimalp+"\n");
//    t.append("The optimal p parameter: "+optimalp+"\n");
    wProgressBar.setValue(prog);
    out.setSize( 400, 400 ); 
    out.setVisible( true );
    ARABS.class1= tempP;     
   }
   wItVector.addElement(new Integer(0));
   wFVector.addElement(new Double(0));
   Finish();
  }
 
  void Finish()
  {  
   w2Button.setEnabled(false);
   w1Button.setEnabled(true);
   w4Button.setEnabled(true);
   if(ARABS.class3==1)
    w3Button.setEnabled(true);
   wTabbedPane.setEnabledAt(0, true);
   wTabbedPane.setEnabledAt(1, true);
//   stop(); 
  }
  void Show(OutputFrame out)
  {
   out.setSize( 400, 400 ); 
   out.setVisible( true );
   Finish();  
  }
 
  public void StopCount()
  {
   Stop = true;
  }
 }

//---------ActionListener----------------Grafic----------------------------------------
 public class Grafic implements ActionListener 
 {
  public void actionPerformed(ActionEvent e) 
  {  
   int X = 10, Y = 10, Xx = 350, Yy = 300;          
   if (wGFrame != null)
   {
    X = wGFrame.getX();
    Y = wGFrame.getY();
    Xx = wGFrame.getWidth();
    Yy = wGFrame.getHeight();
    wGFrame.dispose();
   }
   Iterations=ARABS.class1;
   wGFrame = new JFrame("Residuals graphic");
   MeCanvas mCanvas = new MeCanvas(Iterations, wItVector, wFVector);
   mCanvas.repaint();
   wGFrame.getContentPane().add(mCanvas);
   wGFrame.setLocation(X, Y);
   wGFrame.setSize(Xx, Yy);
   wGFrame.setVisible(true);
  }
 }  
//---------ActionListener----------------For Simple File read----------------------------------------

 public class PicFile implements ActionListener 
 {
  ReadDataFile  RDF= new ReadDataFile();
 
  public void actionPerformed(ActionEvent e) 
  {
   t.setText("");
   RDF.SimpleRead(Dir, IFile,t);
  }
 }  
//-------------------------------------------------------------------------------------------------------
 public class Stop implements ActionListener 
 {
  ReadDataFile  RDF= new ReadDataFile();
  public void actionPerformed(ActionEvent e) 
  {
   int acount, sel1, sel2, p;
   Object wObject = e.getSource();
   if ( wObject == w1Button) 
   {
    if (wGFrame != null)
     wGFrame.dispose();
    acount= RDF.ReadData(Dir, IFile);
    p=  ARABS.class1;
    if (acount<2)
    {
     JOptionPane.showMessageDialog(null, "Invalid Data file format!", "Warning!", JOptionPane.WARNING_MESSAGE);
    }
    else if(acount<(ARABS.class2*(ARABS.class0)+ARABS.class2*ARABS.class0*ARABS.class4))
    {
     acount=((acount/ARABS.class0)/(1+ARABS.class4));
     if (acount<1)
     {
      JOptionPane.showMessageDialog(null, "Number of factors (M) exceeds data!", "Warning!", JOptionPane.WARNING_MESSAGE);
     }
     else
     {
      Object[] options1 = { "  Ok  " };
      sel1 = JOptionPane.showOptionDialog(
             null, "File doesn't contain as much data as needed", "Warning!", JOptionPane.DEFAULT_OPTION,
             JOptionPane.WARNING_MESSAGE, null, options1, options1[0]);
      if ( options1[sel1] == "  Ok  " )
      {   
       if (acount<p)
       {
        p=  acount-1;
       }
       Object[] options2 = { "  Yes  ", " Cancel " };
       sel2 = JOptionPane.showOptionDialog(
              null, "Ajust parameters acording to data file into:   p = "+p+ " ,  T = "+acount +"  and  continue calculation? ", "Warning!", JOptionPane.CLOSED_OPTION,
              JOptionPane.WARNING_MESSAGE, null, options2, options2[0]);
       if ( options2[sel2] == "  Yes  " )
       {
        ARABS.class1=p;
        w2nTextField[1].setText(""+ p);
        ARABS.class2=acount;
        w2nTextField[2].setText(""+acount);
        w1Button.setEnabled(false);
        w4Button.setEnabled(false);
        w3Button.setEnabled(false);
        w2Button.setEnabled(true);
        wTabbedPane.setEnabledAt(0, false);
        wTabbedPane.setEnabledAt(1, false);
        try 
        {
         PC= new PerformCount();  
         PC.setPriority(PC.MIN_PRIORITY);
         PC.start();
        }
        catch (Exception ex) 
        {
         w1Button.setEnabled(true);
         w2Button.setEnabled(false);
         w4Button.setEnabled(false);
         wTabbedPane.setEnabledAt(0, true);
         wTabbedPane.setEnabledAt(1, true);
        } 
       }
      }
     }
    }
    else
    {
     w1Button.setEnabled(false);
     w2Button.setEnabled(true);
     w4Button.setEnabled(false);
     w3Button.setEnabled(false);    
     wTabbedPane.setEnabledAt(0, false);
     wTabbedPane.setEnabledAt(1, false);
     try
     {
      PC= new PerformCount();  
      PC.setPriority(PC.MIN_PRIORITY);
      PC.start();
     }
     catch (Exception ex) 
     {
      w1Button.setEnabled(true);
      w2Button.setEnabled(false);
      w4Button.setEnabled(false);
      wTabbedPane.setEnabledAt(0, true);
      wTabbedPane.setEnabledAt(1, true);
     } 
    }
   }
   else if ( wObject == w2Button) 
   {
    PC.StopCount();
    w2Button.setEnabled(false);
   }
  }
 }
//=============================================================================ReadDataFile classs 
 public class ReadDataFile
 {   //-------------------------------------------------ReadData- reads inicial data   
  public int ReadData( String Dir, String IFile )
  {
   File DM = new File(Dir);
   int i=1, ret=1;
   String tem =new String(); 
   try 
   {
    URL ur2 = new URL(getDocumentBase(),IFile);
    if ( Dir.compareTo("")!= 0)
    { 
     ur2=DM.toURL();
    } 
    if (IFile.compareTo("call.data")==0)
     FileIdent=1000;
    else
     FileIdent=1;   
    t.setText(ur2+"\n");
    InputStream is = ur2.openStream();
    BufferedReader in = new BufferedReader( new InputStreamReader(is));
    String line="";
    while ((line = in.readLine()) != null)
    {
     if (i <= (ARABS.class2*(ARABS.class0)+ARABS.class2*ARABS.class0*ARABS.class4))
     {
//      StringTokenizer line1 = new StringTokenizer(line);
//      int m=1;
//      if (IFile.compareTo("call.data")==0) 
//      {
//       tem=line1.nextToken(); 
//       tem=line1.nextToken(); 
//       tem=line1.nextToken(); 
//       tem=line1.nextToken();
//      } 
//      while (line1.hasMoreTokens())
//      {
//       if(m <= (ModelAR_ABS.class0))
//       {
        ModelAR_ABS.past[i]= Double.valueOf(line).doubleValue();
//        ModelAR_ABS.past[i]= Double.valueOf(line1.nextToken()).doubleValue();
//        t.append("w[ "+i+" ]   "+ModelAR_ABS.past[i]+ "\n");
        i++;
//        m++;
        ret=i;
//       }
//       else
//        tem= line1.nextToken();
//      }
     }
//     else if((i==(  ModelAR_ABS.class2*(ModelAR_ABS.class0)+1))&&(ModelAR_ABS.class4==0))
//     {
//      Bcompare = true;
//      StringTokenizer line1 = new StringTokenizer(line);
 //     int m=1;
//      if (IFile.compareTo("call.data")==0) 
//      {
//       tem=line1.nextToken(); 
//       tem=line1.nextToken(); 
//       tem=line1.nextToken(); 
//       tem=line1.nextToken();
//      } 
//      while (line1.hasMoreTokens())
//      {
//       if(m <= (ModelAR_ABS.class0))
//       {
//        ModelAR_ABS.past[i]= Double.valueOf(line).doubleValue();
//        ModelAR_ABS.past[i]= Double.valueOf(line1.nextToken()).doubleValue();
        //System.out.println("w[ "+i+" ]   "+ModelAR_ABS.past[i]+ "\n");
//        i++;
//        m++;
//       }
//       else
//        tem= line1.nextToken();
//      }
     }
    }
   }
   catch(Exception ex)
   {
//    t.append(ex.toString());
   } 
   return ret-1;
  }
  public void SimpleRead( String Dir, String IFile, JTextArea t )
  {   //-------------------------------------------------------------SimpleRead- reads any File as text    
   File DM = new File(Dir);
   try 
   {
    URL ur2 = new URL(getDocumentBase(),IFile);
    if ( Dir.compareTo("")!= 0)
    { 
     ur2=DM.toURL();
    } 
    t.append(ur2+"\n");
    InputStream is = ur2.openStream();
    BufferedReader in = new BufferedReader( new InputStreamReader(is));
    String line="";
    while ((line = in.readLine()) != null)
    {
     t.append(line+"\n");
    } 
   }
   catch(Exception ex)
   {
    t.append(ex.toString());
   } 
  }
  public boolean ReadLp( String Dir, String IIFile, JTextArea t )
  {    //-------------------------------------------------------------ReadLp- reads Lp_solve generated File  
  
   double aa[] = new double[ARABS.class1*ARABS.class0*2+1];
   String  g =new String();
   String line = new String();
   File DM = new File(Dir);
   boolean Ok=true;
   try 
   {
    URL ur2 = new URL(getDocumentBase(),"out_data.lp");
    if ( Dir.compareTo("")!= 0)
    { 
     ur2=DM.toURL();
    } 
    InputStream is = ur2.openStream();
    BufferedReader in = new BufferedReader( new InputStreamReader(is));
    line="";
    int k=1;
    line=in.readLine();
    System.out.println("k444444444 "+line);
    while ((line = in.readLine()) != null)
    {
     if (line== null)
      Ok=false;
     StringTokenizer line1 = new StringTokenizer(line); 
     g=line1.nextToken();
     if (g.startsWith("a"))
     {
      g= g.substring(1);
      k= Short.valueOf(g).shortValue()-ARABS.class2;
      //System.out.println("  g   "+g+"   k   "+k);
      while (line1.hasMoreTokens())
       aa[k]= Double.valueOf(line1.nextToken()).doubleValue();
      //System.out.println("aa[k]"+aa[k]);
     }
    } 
    k=1;
    int i=1;
    while (k < ARABS.class1*ARABS.class0*2)
    {
     ARABS.Acoef[i]=aa[k]-aa[k+1];
     k=k+2;
     //System.out.println("ARABS.Acoef[ "+i+" ]  "+ARABS.Acoef[i]);
     i++;
    }
   }
   catch(Exception ex) 
   {
    System.out.println(ex);
    getAppletContext().showStatus("aaaaaa"+ex);
   } 
   return Ok;
  } 
 }
//**************************************************************/    
//**************************************************************/
 public void init ()
 { //2
  // Force SwingApplet to come up in the System L&F 
  String laf = UIManager.getCrossPlatformLookAndFeelClassName();
  String laf1 = UIManager.getSystemLookAndFeelClassName();
  try 
  { //3
   System.out.println("");
   System.err.println("Started");
   UIManager.setLookAndFeel(laf1);
   System.err.println("Found LookAndFeel: " + laf);
   System.out.println("");
  }  //3
  catch (UnsupportedLookAndFeelException exc) 
  { //4
   System.err.println("Warning: UnsupportedLookAndFeel: " + laf);
  }  //4
  catch (Exception exc) 
  { //5
   System.err.println("Error loading " + laf + ": " + exc);
  } //5
  //--------------------------------------------------------------  
  getContentPane().setLayout(new BorderLayout()); 
  setSize(700, 450);
  ParamWidth = 700;
  ParamHeight = 450;
 
  ModelAR_ABS = new ARABS();
  Model = "AR-ABS";
  IFile=DefaultFile;
  String[] Inputfieldnames = new String[ModelAR_ABS.InputsNumber];
  Inputfieldnames[0] = " Number of factors (M) : ";
  Inputfieldnames[1] = " AR parameter (p) :";
  Inputfieldnames[2] = " Number of data entrees (T) :";
  Inputfieldnames[3] = " Indikator for one p evaluation (0), increasing p(1) :";
  Inputfieldnames[4] = " Indikator for one step evaluation(0), multistep(1) :";

  //--------------- MODEL --------------------------  
  int l = 25;
  w1Panel = new JPanel();
  w1Panel.setLayout(null);
  
  w11Label = new JLabel("Model to expirement and apply-");
  w11Label.setBounds(15, 25, ParamWidth-200, height);
  w11Label.setOpaque(true);
  w11Label.setBackground(new Color(161, 161, 161));
  w11Label.setForeground(new Color(66, 75, 145));
  w1Panel.add(w11Label);
   
  Left = ParamWidth-200+30;
  w12Label = new JLabel("  AR-ABS ");
  w12Label.setBounds(Left, 25, width, height);
  w12Label.setOpaque(true);
  w12Label.setBackground(new Color(161, 161, 161));
  w12Label.setForeground(new Color(66, 75, 145));
  w1Panel.add(w12Label);
   
  w13Label = new JLabel("  Select a data file ");
  w13Label.setBounds(15, (33*2)+l,ParamWidth-200, height);
  w13Label.setOpaque(true);
  w13Label.setBackground(new Color(161, 161, 161));
  w13Label.setForeground(new Color(66, 75, 145));
  w1Panel.add(w13Label);
   
  w11Button = new JButton("Default");
  w11Button.setToolTipText("Default file - armatest");
  w11Button.setBounds(Left,(33*2)+l, width, height);
  w11Button.addActionListener(new  ActionListener()
  {
   public void actionPerformed(ActionEvent e) 
   {
    if (e.getSource()==w11Button)
    {
     w11TextField.setText(DefaultFile);
     IFile=DefaultFile;
     Dir= "";
     getAppletContext().showStatus(IFile);
    }
   }
  }
  );
  w1Panel.add(w11Button);
   
  w11TextField = new JTextField(DefaultFile);
  w11TextField.setBounds(15, (33*3)+l, ParamWidth-200, height);
  w11TextField.addFocusListener(new FocusListener()
  {
   public void focusGained(FocusEvent e)
   {        
   }
   public void focusLost(FocusEvent e)
   {                  
    IFile = ((JTextField)e.getSource()).getText();  
    w11TextField.setText(IFile);
    Dir= "";
    getAppletContext().showStatus(IFile); 
   } 
  }
  );
  w1Panel.add(w11TextField);
           
  w12Button = new JButton("Browse...");
  w12Button.setBounds(Left,(33*3)+l, width, height);
  w12Button.addActionListener(wFActionListener);
  w1Panel.add(w12Button);
   
//------- Inputs -----------------------------------------------------   
  w2Panel = new JPanel();
  w2Panel.setLayout(null);
   
  w21Label = new JLabel("  Property ");
  w21Label.setBounds(15, 25, ParamWidth-200, height);
  w21Label.setOpaque(true);
  w21Label.setBackground(new Color(161, 161, 161));
  w21Label.setForeground(new Color(66, 75, 145));
  w2Panel.add(w21Label);
   
  Left = ParamWidth-200+30;
  w22Label = new JLabel("  Value ");
  w22Label.setBounds(Left, 25, width, height);
  w22Label.setOpaque(true);
  w22Label.setBackground(new Color(161, 161, 161));
  w22Label.setForeground(new Color(66, 75, 145));
  w2Panel.add(w22Label);
  w2nTextField[0] = new JTextField(""+ModelAR_ABS.class0);
  w2nTextField[1] = new JTextField(""+ModelAR_ABS.class1);
  w2nTextField[2] = new JTextField(""+ModelAR_ABS.class2);
  w2nTextField[3] = new JTextField(""+ModelAR_ABS.class3);
  w2nTextField[4] = new JTextField(""+ModelAR_ABS.class4);
  for (int i=0; i<5; i++)
  {
   w2nLabel[i] = new JLabel(Inputfieldnames[i]);
   w2nLabel[i].setBounds(25, (33*(i+1))+l, ParamWidth-200, height);
   w2Panel.add(w2nLabel[i]);
   w2nTextField[i].setBounds(Left,(33*(i+1))+l, width, height);
   w2nTextField[i].addFocusListener(wTSFocusListener);
   w2Panel.add(w2nTextField[i]);
  } 
  w2nTextField[1].setToolTipText("p value must be less than T "); 
  w2nTextField[2].setToolTipText("T value must be greater than p"); 
  w2nTextField[3].setToolTipText("1-multi step; 0-one step ");    
  w2nTextField[4].setToolTipText("1-p increasing; 0-p constant ");
//--------------- COUNT ----------------------------
  w3Panel = new JPanel();
  w3Panel.setLayout(null);
  
  w31Label = new JLabel(Model);
  w31Label.setBounds(15, 25, ParamWidth-35, height);
  w31Label.setOpaque(true);
  w31Label.setBackground(new Color(161, 161, 161));
  w31Label.setForeground(new Color(66, 75, 145));
  w3Panel.add(w31Label);   
   
  int LeftWidth = (ParamWidth-45)/4;
  w1Button = new JButton("Count");
  w1Button.setToolTipText("Start Counting ");  
  w1Button.setBounds(25, ParamHeight-80, LeftWidth-10, height);
  w1Button.addActionListener(new Stop());
  w1Button.setEnabled(true);
  w3Panel.add(w1Button);
  w2Button = new JButton("Stop");
  w2Button.setToolTipText("Stop Counting ");  
  w2Button.setBounds(25+LeftWidth, ParamHeight-80, LeftWidth-10, height);
  w2Button.addActionListener( new Stop());
  w2Button.setEnabled(false);
  w3Panel.add(w2Button);
  w3Button = new JButton("Graphic");
  w3Button.setToolTipText("View Graphic ");  
  w3Button.setBounds(25+LeftWidth*2, ParamHeight-80, LeftWidth-10, height);
  w3Button.setEnabled(false);
  w3Button.addActionListener(new Grafic());
  w3Panel.add(w3Button);
  w4Button = new JButton("Data");
  w4Button.setToolTipText("View Data File");  
  w4Button.setBounds(25+LeftWidth*3, ParamHeight-80, LeftWidth-10, height);
  w4Button.setEnabled(true);
  w4Button.addActionListener(new PicFile());
  w3Panel.add(w4Button);
  //--- COUNT ScrollPane -------------------------------------------    
  wScrollPane = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS, JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
  wScrollPane.setBounds(15, 33+l, ParamWidth-35, ParamHeight-160);
  wScrollPane.setViewportView(t);
  t.setEditable(false);
  w3Panel.add(wScrollPane);   
           //--- COUNT ProgressBar -------------------------------------------    
  wProgressBar.setBounds(15, ParamHeight-98, ParamWidth-35, 10);
  wProgressBar.setValue(0);
  wProgressBar.setBorderPainted(true);
  w3Panel.add(wProgressBar);    
  System.err.println(" Added Count");
//----------------------------------------------------------------
     
  wTabbedPane.addTab(Name1, w1Panel); 
  wTabbedPane.addTab(Name2, w2Panel); 
  wTabbedPane.addTab(Name3, w3Panel); 
  wPopupMenu1 = new JPopupMenu();
  wMenuItem1 = new JMenuItem();
  wMenuItem1.setText("Hellp..");
  wPopupMenu1.add(wMenuItem1);
  wMenuItem1.addActionListener(new Popup1());
 
  wPopupMenu2 = new JPopupMenu();
  wMenuItem2 = new JMenuItem();
  wMenuItem2.setText("Hellp..");
  wPopupMenu2.add(wMenuItem2);
  wMenuItem2.addActionListener(new Popup1());
 
  wPopupMenu3 = new JPopupMenu();
  wMenuItem3 = new JMenuItem();
  wMenuItem3.setText("Hellp..");
  wPopupMenu3.add(wMenuItem3);
  wMenuItem3.addActionListener(new Popup1());
  t.addMouseListener(wPMouseAdapter);
 
  w1Panel.addMouseListener(wPMouseAdapter);
  w2Panel.addMouseListener(wPMouseAdapter);
  w3Panel.addMouseListener(wPMouseAdapter);
  getContentPane().add(wTabbedPane);     
  System.out.println("");    
  System.err.println("Finished");
 } 
}
